

def describe_observation(observation, last_observation):
    obs, last_obs = observation[-1], last_observation[-1]
    status = obs['status']
    inventory = obs['inventory']

    # Describe the bot's current position and orientation
    position = status['position']
    velocity = status['velocity']
    yaw = status['yaw']
    pitch = status['pitch']
    biome = status['biome']
    health = status['health']
    food = status['food']
    saturation = status['saturation']
    time_of_day = status['timeOfDay']

    description = (f"You are currently located at position "
                   f"(x: {position['x']:.2f}, y: {position['y']:.2f}, z: {position['z']:.2f}) in a {biome} biome. "
                   f"It is facing yaw: {yaw:.2f} and pitch: {pitch:.2f}. "
                   f"You have health: {health}, food: {food}, and saturation: {saturation}. "
                   f"The current time of day is {time_of_day}. "
                   f"Your velocity is (x: {velocity['x']:.2f}, y: {velocity['y']:.2f}, z: {velocity['z']:.2f}).")

    # Describe entities around the bot
    entities = status['entities']
    if entities:
        entity_descriptions = []
        for entity, distance in entities.items():
            entity_descriptions.append(f"a {entity} at {distance:.2f} blocks away")
        description += " Nearby entities include: " + ", ".join(entity_descriptions) + "."

    # Describe nearby blocks
    voxels = obs['voxels']
    if voxels:
        description += f" You are surrounded by blocks such as {', '.join(voxels)}."

    # Describe inventory changes
    last_inventory = last_obs['inventory']
    inventory_changes = []
    
    # Check for items in the current inventory
    for item, quantity in inventory.items():
        last_quantity = last_inventory.get(item, 0)
        if quantity != last_quantity:
            change = quantity - last_quantity
            if change > 0:
                inventory_changes.append(f"gained {change} of {item}")
            else:
                inventory_changes.append(f"lost {-change} of {item}")

    # Check for items in the last inventory that are now zero in the current inventory
    for item, last_quantity in last_inventory.items():
        if item not in inventory:
            inventory_changes.append(f"lost {last_quantity} of {item}")

    if inventory_changes:
        description += " Since the last observation, you have " + ", ".join(inventory_changes) + "."

    return description


if __name__ == "__main__":
    # Example usage:
    observation = ['observe', {'voxels': ['stone', 'dirt', 'grass_block', 'coal_ore'], 'status': {'health': 20, 'food': 20, 'saturation': 5, 'position': {'x': 4.5, 'y': 90, 'z': 25.5}, 'velocity': {'x': 0, 'y': -0.0784000015258789, 'z': 0}, 'yaw': -3.1415926535866685, 'pitch': -1.5707963267948966, 'onGround': True, 'equipment': [None, None, None, None, 'dirt', None], 'name': 'bot', 'isInWater': False, 'isInLava': False, 'isCollidedHorizontally': False, 'isCollidedVertically': True, 'biome': 'jungle', 'entities': {'parrot': 19.77261575820649, 'chicken': 23.00125199371402}, 'timeOfDay': 'day', 'inventoryUsed': 1, 'elapsedTime': 13}, 'inventory': {'dirt': 1}, 'nearbyChests': {}, 'blockRecords': ['stone', 'dirt', 'grass_block', 'coal_ore']}]

    last_inventory = ['observe', {'inventory': {'dirt': 2}}]  # Example of the last inventory state

    description = describe_observation(observation, last_inventory)
    print(description)
